﻿using System;
using System.Collections.Generic;
using System.ComponentModel;
using System.Data;
using System.Drawing;
using System.Linq;
using System.Text;
using System.Threading.Tasks;
using System.Windows.Forms;
using System.IO;

namespace Grupa_C
{
    public partial class Form1 : Form
    {
        double[,] podaci = new double[10954, 2];

        public Form1()
        {
            InitializeComponent();
        }

        private void btnUcitaj_Click(object sender, EventArgs e)
        {
            try
            {
                StreamReader reader = new StreamReader("podaciC.txt");

                int trenutniRedak = 0;

                while (!reader.EndOfStream)
                {
                    string linija = reader.ReadLine();
                    string[] dijeloviLinije = linija.Split(':');

                    podaci[trenutniRedak, 0] = Convert.ToDouble(dijeloviLinije[0]);
                    podaci[trenutniRedak, 1] = Convert.ToDouble(dijeloviLinije[1]);

                    trenutniRedak++;
                }

                reader.Close();

                MessageBox.Show("Podaci su učitani!");
            }
            catch (Exception ex)
            {
                MessageBox.Show("Greška: " + ex.Message);
            }
        }

        private void btnObradi_Click(object sender, EventArgs e)
        {
            double donjaGranica = 0.0;
            double gornjaGranica = 100.0;

            int zeljenaKategorija = Convert.ToInt32(txtKategorija.Text);

            if (zeljenaKategorija == 1)
            {
                donjaGranica = 0;
                gornjaGranica = 4.5;
            }
            else if (zeljenaKategorija == 2)
            {
                donjaGranica = 4.5;
                gornjaGranica = 6.4;
            }
            else if (zeljenaKategorija == 3)
            {
                donjaGranica = 6.4;
                gornjaGranica = 14.6;
            }
            else if (zeljenaKategorija == 4)
            {
                donjaGranica = 14.6;
                gornjaGranica = 100;
            }

            int brojPodataka = 0;
            double zbrojDuljina = 0.0;

            for (int i = 0; i < podaci.GetLength(0); i++)
            {
                if (podaci[i, 0] > donjaGranica && podaci[i, 0] <= gornjaGranica)
                {
                    brojPodataka++;
                    zbrojDuljina += podaci[i, 0];
                }
            }

            double prosjecnaDuljinaVozila = zbrojDuljina / brojPodataka;
            double devijacija = 0.0;

            for (int i = 0; i < podaci.GetLength(0); i++)
            {
                if (podaci[i, 0] > donjaGranica && podaci[i, 0] <= gornjaGranica)
                {
                    devijacija += Math.Pow(podaci[i, 0] - prosjecnaDuljinaVozila, 2);
                }
            }

            devijacija = Math.Sqrt(devijacija / brojPodataka);

            txtBrojPodataka.Text = Convert.ToString(brojPodataka);
            txtProsjek.Text = Convert.ToString(prosjecnaDuljinaVozila);
            txtDevijacija.Text = Convert.ToString(devijacija);
        }
    }
}